/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanResult
implements Serializable {
    private ListWithAutoConstructFlag<Map<String, AttributeValue>> items;
    private Integer count;
    private Integer scannedCount;
    private Map<String, AttributeValue> lastEvaluatedKey;
    private ConsumedCapacity consumedCapacity;

    public List<Map<String, AttributeValue>> getItems() {
        return this.items;
    }

    public void setItems(Collection<Map<String, AttributeValue>> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        ListWithAutoConstructFlag itemsCopy = new ListWithAutoConstructFlag(items.size());
        itemsCopy.addAll(items);
        this.items = itemsCopy;
    }

    public ScanResult withItems(Map<String, AttributeValue> ... items) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<Map<String, AttributeValue>>(items.length));
        }
        for (Map<String, AttributeValue> value : items) {
            this.getItems().add(value);
        }
        return this;
    }

    public ScanResult withItems(Collection<Map<String, AttributeValue>> items) {
        if (items == null) {
            this.items = null;
        } else {
            ListWithAutoConstructFlag itemsCopy = new ListWithAutoConstructFlag(items.size());
            itemsCopy.addAll(items);
            this.items = itemsCopy;
        }
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public ScanResult withCount(Integer count) {
        this.count = count;
        return this;
    }

    public Integer getScannedCount() {
        return this.scannedCount;
    }

    public void setScannedCount(Integer scannedCount) {
        this.scannedCount = scannedCount;
    }

    public ScanResult withScannedCount(Integer scannedCount) {
        this.scannedCount = scannedCount;
        return this;
    }

    public Map<String, AttributeValue> getLastEvaluatedKey() {
        return this.lastEvaluatedKey;
    }

    public void setLastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey) {
        this.lastEvaluatedKey = lastEvaluatedKey;
    }

    public ScanResult withLastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey) {
        this.setLastEvaluatedKey(lastEvaluatedKey);
        return this;
    }

    public ScanResult addLastEvaluatedKeyEntry(String key, AttributeValue value) {
        if (null == this.lastEvaluatedKey) {
            this.lastEvaluatedKey = new HashMap<String, AttributeValue>();
        }
        if (this.lastEvaluatedKey.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.lastEvaluatedKey.put(key, value);
        return this;
    }

    public ScanResult clearLastEvaluatedKeyEntries() {
        this.lastEvaluatedKey = null;
        return this;
    }

    public ConsumedCapacity getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(ConsumedCapacity consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
    }

    public ScanResult withConsumedCapacity(ConsumedCapacity consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getItems() != null) {
            sb.append("Items: " + this.getItems() + ",");
        }
        if (this.getCount() != null) {
            sb.append("Count: " + this.getCount() + ",");
        }
        if (this.getScannedCount() != null) {
            sb.append("ScannedCount: " + this.getScannedCount() + ",");
        }
        if (this.getLastEvaluatedKey() != null) {
            sb.append("LastEvaluatedKey: " + this.getLastEvaluatedKey() + ",");
        }
        if (this.getConsumedCapacity() != null) {
            sb.append("ConsumedCapacity: " + this.getConsumedCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        hashCode = 31 * hashCode + (this.getCount() == null ? 0 : this.getCount().hashCode());
        hashCode = 31 * hashCode + (this.getScannedCount() == null ? 0 : this.getScannedCount().hashCode());
        hashCode = 31 * hashCode + (this.getLastEvaluatedKey() == null ? 0 : this.getLastEvaluatedKey().hashCode());
        hashCode = 31 * hashCode + (this.getConsumedCapacity() == null ? 0 : this.getConsumedCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanResult)) {
            return false;
        }
        ScanResult other = (ScanResult)obj;
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (other.getItems() != null && !other.getItems().equals(this.getItems())) {
            return false;
        }
        if (other.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (other.getCount() != null && !other.getCount().equals(this.getCount())) {
            return false;
        }
        if (other.getScannedCount() == null ^ this.getScannedCount() == null) {
            return false;
        }
        if (other.getScannedCount() != null && !other.getScannedCount().equals(this.getScannedCount())) {
            return false;
        }
        if (other.getLastEvaluatedKey() == null ^ this.getLastEvaluatedKey() == null) {
            return false;
        }
        if (other.getLastEvaluatedKey() != null && !other.getLastEvaluatedKey().equals(this.getLastEvaluatedKey())) {
            return false;
        }
        if (other.getConsumedCapacity() == null ^ this.getConsumedCapacity() == null) {
            return false;
        }
        return other.getConsumedCapacity() == null || other.getConsumedCapacity().equals(this.getConsumedCapacity());
    }
}

